unit frmMain;

//------------------------------------------------------------------------------
//     Performance Counter Sample
//     This sample is originally inspired from a MSDN Sample with some additional
//     features.
//
//     This code is released to the Delphi .NET community
//     I accept no liabilities for damage, use at your own risk.
//
//     Written by:  Dave Bhatia, Tara Group, Inc. dbhatia@taragroup.com
//------------------------------------------------------------------------------

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,  System.Windows.Forms, System.Data, System.Diagnostics, System.Net;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    lblCounterValue: System.Windows.Forms.Label;
    txtValue: System.Windows.Forms.TextBox;
    lblSystemCounterValue: System.Windows.Forms.Label;
    btnSetRawValue: System.Windows.Forms.Button;
    btnGetNextValue: System.Windows.Forms.Button;
    btnIncrement: System.Windows.Forms.Button;
    btnDecrement: System.Windows.Forms.Button;
    btnIncrementBy: System.Windows.Forms.Button;
    Label3: System.Windows.Forms.Label;
    Label4: System.Windows.Forms.Label;
    LinkLabel1: System.Windows.Forms.LinkLabel;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    GroupBox1: System.Windows.Forms.GroupBox;
    btnDeleteCounter: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnSetRawValue_Click(sender: System.Object; e: System.EventArgs);
    procedure btnGetNextValue_Click(sender: System.Object; e: System.EventArgs);
    procedure btnIncrement_Click(sender: System.Object; e: System.EventArgs);
    procedure btnDecrement_Click(sender: System.Object; e: System.EventArgs);
    procedure btnIncrementBy_Click(sender: System.Object; e: System.EventArgs);
    procedure LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
    procedure btnDeleteCounter_Click(sender: System.Object; e: System.EventArgs);
  private
    procedure InitPerfCounter1;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    performanceCounter1 : System.Diagnostics.PerformanceCounter;
    performanceCounter2 : System.Diagnostics.PerformanceCounter;
    procedure InitPerfCounter2;
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.lblCounterValue := System.Windows.Forms.Label.Create;
  Self.txtValue := System.Windows.Forms.TextBox.Create;
  Self.lblSystemCounterValue := System.Windows.Forms.Label.Create;
  Self.btnSetRawValue := System.Windows.Forms.Button.Create;
  Self.btnGetNextValue := System.Windows.Forms.Button.Create;
  Self.btnIncrement := System.Windows.Forms.Button.Create;
  Self.btnDecrement := System.Windows.Forms.Button.Create;
  Self.btnIncrementBy := System.Windows.Forms.Button.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.LinkLabel1 := System.Windows.Forms.LinkLabel.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.btnDeleteCounter := System.Windows.Forms.Button.Create;
  Self.GroupBox1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // lblCounterValue
  // 
  Self.lblCounterValue.Location := System.Drawing.Point.Create(16, 8);
  Self.lblCounterValue.Name := 'lblCounterValue';
  Self.lblCounterValue.Size := System.Drawing.Size.Create(232, 23);
  Self.lblCounterValue.TabIndex := 0;
  Self.lblCounterValue.Text := '0';
  // 
  // txtValue
  // 
  Self.txtValue.Location := System.Drawing.Point.Create(112, 72);
  Self.txtValue.Name := 'txtValue';
  Self.txtValue.TabIndex := 1;
  Self.txtValue.Text := '10';
  //
  // lblSystemCounterValue
  // 
  Self.lblSystemCounterValue.Location := System.Drawing.Point.Create(16, 40);
  Self.lblSystemCounterValue.Name := 'lblSystemCounterValue';
  Self.lblSystemCounterValue.Size := System.Drawing.Size.Create(320, 23);
  Self.lblSystemCounterValue.TabIndex := 2;
  Self.lblSystemCounterValue.Text := '0';
  // 
  // btnSetRawValue
  // 
  Self.btnSetRawValue.Location := System.Drawing.Point.Create(40, 104);
  Self.btnSetRawValue.Name := 'btnSetRawValue';
  Self.btnSetRawValue.Size := System.Drawing.Size.Create(304, 24);
  Self.btnSetRawValue.TabIndex := 3;
  Self.btnSetRawValue.Text := 'Click this First - Create Counter';
  Include(Self.btnSetRawValue.Click, Self.btnSetRawValue_Click);
  // 
  // btnGetNextValue
  // 
  Self.btnGetNextValue.Location := System.Drawing.Point.Create(40, 168);
  Self.btnGetNextValue.Name := 'btnGetNextValue';
  Self.btnGetNextValue.Size := System.Drawing.Size.Create(304, 24);
  Self.btnGetNextValue.TabIndex := 4;
  Self.btnGetNextValue.Text := 'Get Next Value of System Counter';
  Include(Self.btnGetNextValue.Click, Self.btnGetNextValue_Click);
  // 
  // btnIncrement
  // 
  Self.btnIncrement.Location := System.Drawing.Point.Create(40, 200);
  Self.btnIncrement.Name := 'btnIncrement';
  Self.btnIncrement.Size := System.Drawing.Size.Create(304, 24);
  Self.btnIncrement.TabIndex := 5;
  Self.btnIncrement.Text := 'Increase the Custom Counter by 1';
  Include(Self.btnIncrement.Click, Self.btnIncrement_Click);
  // 
  // btnDecrement
  // 
  Self.btnDecrement.Location := System.Drawing.Point.Create(40, 232);
  Self.btnDecrement.Name := 'btnDecrement';
  Self.btnDecrement.Size := System.Drawing.Size.Create(304, 24);
  Self.btnDecrement.TabIndex := 6;
  Self.btnDecrement.Text := 'Decrease the Custom Counter by 1';
  Include(Self.btnDecrement.Click, Self.btnDecrement_Click);
  // 
  // btnIncrementBy
  // 
  Self.btnIncrementBy.Location := System.Drawing.Point.Create(40, 264);
  Self.btnIncrementBy.Name := 'btnIncrementBy';
  Self.btnIncrementBy.Size := System.Drawing.Size.Create(304, 24);
  Self.btnIncrementBy.TabIndex := 7;
  Self.btnIncrementBy.Text := 'Increase the Custom Counter by Value';
  Include(Self.btnIncrementBy.Click, Self.btnIncrementBy_Click);
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(56, 72);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(48, 16);
  Self.Label3.TabIndex := 8;
  Self.Label3.Text := 'Value';
  // 
  // Label4
  // 
  Self.Label4.Location := System.Drawing.Point.Create(16, 64);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(264, 32);
  Self.Label4.TabIndex := 9;
  Self.Label4.Text := 'Add Counter - Lookup Delphi Counter Sample in Perfor' +
  'mance Object';
  // 
  // LinkLabel1
  // 
  Self.LinkLabel1.Location := System.Drawing.Point.Create(16, 32);
  Self.LinkLabel1.Name := 'LinkLabel1';
  Self.LinkLabel1.Size := System.Drawing.Size.Create(224, 23);
  Self.LinkLabel1.TabIndex := 10;
  Self.LinkLabel1.TabStop := True;
  Self.LinkLabel1.Text := 'Open Performance Monitor';
  Include(Self.LinkLabel1.LinkClicked, Self.LinkLabel1_LinkClicked);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 104);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(256, 16);
  Self.Label1.TabIndex := 11;
  Self.Label1.Text := 'Click on Add';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 128);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(256, 32);
  Self.Label2.TabIndex := 12;
  Self.Label2.Text := 'Increase and Decrease Counter and notice the changes ' +
  'in Last, Average, Minimum';
  // 
  // GroupBox1
  //
  Self.GroupBox1.Controls.Add(Self.LinkLabel1);
  Self.GroupBox1.Controls.Add(Self.Label4);
  Self.GroupBox1.Controls.Add(Self.Label1);
  Self.GroupBox1.Controls.Add(Self.Label2);
  Self.GroupBox1.Location := System.Drawing.Point.Create(40, 296);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(296, 168);
  Self.GroupBox1.TabIndex := 13;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := 'Setup Performance Monitor';
  // 
  // btnDeleteCounter
  // 
  Self.btnDeleteCounter.Location := System.Drawing.Point.Create(40, 136);
  Self.btnDeleteCounter.Name := 'btnDeleteCounter';
  Self.btnDeleteCounter.Size := System.Drawing.Size.Create(304, 23);
  Self.btnDeleteCounter.TabIndex := 14;
  Self.btnDeleteCounter.Text := 'Delete Counter';
  Include(Self.btnDeleteCounter.Click, Self.btnDeleteCounter_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(384, 478);
  Self.Controls.Add(Self.btnDeleteCounter);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.btnIncrementBy);
  Self.Controls.Add(Self.btnDecrement);
  Self.Controls.Add(Self.btnIncrement);
  Self.Controls.Add(Self.btnGetNextValue);
  Self.Controls.Add(Self.btnSetRawValue);
  Self.Controls.Add(Self.lblSystemCounterValue);
  Self.Controls.Add(Self.txtValue);
  Self.Controls.Add(Self.lblCounterValue);
  Self.Name := 'TWinForm';
  Self.Text := 'View and Modify Performance Counter Values';
  Self.GroupBox1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if (Self.performanceCounter1 <> nil) then Self.performanceCounter1.Dispose;
    if (Self.performanceCounter2 <> nil) then Self.performanceCounter2.Dispose;
    //
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;


procedure TWinForm.LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
    System.Diagnostics.Process.Start('perfmon.msc');
end;

procedure TWinForm.btnIncrementBy_Click(sender: System.Object; e: System.EventArgs);
begin
    if (Self.performanceCounter2 <> nil) then
  begin
    Self.performanceCounter2.IncrementBy( Convert.ToInt64( self.txtValue.Text) );
    Self.lblCounterValue.Text := Self.performanceCounter2.RawValue.ToString;
  end;
end;

procedure TWinForm.btnDecrement_Click(sender: System.Object; e: System.EventArgs);
begin
    if (Self.performanceCounter2 <> nil) then
  begin
    Self.performanceCounter2.Decrement;
    Self.lblCounterValue.Text := Self.performanceCounter2.RawValue.ToString;
  end;
end;

procedure TWinForm.btnIncrement_Click(sender: System.Object; e: System.EventArgs);
begin
  if (Self.performanceCounter2 <> nil) then
  begin
    Self.performanceCounter2.Increment;
    Self.lblCounterValue.Text := Self.performanceCounter2.RawValue.ToString;
  end;
end;

procedure TWinForm.btnGetNextValue_Click(sender: System.Object; e: System.EventArgs);
begin
    Self.lblSystemCounterValue.Text := ('The current value of the system counter is: ' 
      + Self.performanceCounter1.NextValue.ToString);
end;

procedure TWinForm.InitPerfCounter2;
begin
  Self.performanceCounter2 := System.Diagnostics.PerformanceCounter.Create;
  Self.performanceCounter2.CategoryName := 'Delphi Counter Sample';
  Self.performanceCounter2.CounterName := 'TestHits';
  Self.performanceCounter2.InstanceName := '_Total';
  Self.performanceCounter2.ReadOnly := False;
  Self.performanceCounter2.MachineName := System.Net.Dns.GetHostName;
  //
  Self.performanceCounter2.Increment;
end;


procedure TWinForm.InitPerfCounter1;
begin
  //
  Self.performanceCounter1 := PerformanceCounter.Create;
  Self.performanceCounter1.CategoryName := 'Process';
  Self.performanceCounter1.CounterName := '% Processor Time';
  Self.performanceCounter1.InstanceName := '_Total';
  Self.performanceCounter1.MachineName := System.Net.Dns.GetHostName;
end;

procedure TWinForm.btnSetRawValue_Click(sender: System.Object; e: System.EventArgs);
var
 CCDC : CounterCreationDataCollection;
 NewCounter : CounterCreationData;
begin
     self.InitPerfCounter1;  // View Processor Counter values
     //
     if PerformanceCounterCategory.Exists( 'Delphi Counter Sample' )=false then
       begin
          CCDC := CounterCreationDataCollection.Create;
          // Add Counter
          NewCounter := CounterCreationData.Create;
          NewCounter.CounterType :=  PerformanceCounterType.NumberOfItems64;
          NewCounter.CounterName := 'TestHits';
          CCDC.Add( NewCounter );

          // Create the Category
          PerformanceCounterCategory.&Create( 'Delphi Counter Sample', 'Demonstrates usage of the Performance Counters using Delphi.', CCDC );
       end; // if

     Self.InitPerfCounter2;
end;

procedure TWinForm.btnDeleteCounter_Click(sender: System.Object; e: System.EventArgs);
begin
  if PerformanceCounterCategory.Exists('Delphi Counter Sample') then
    PerformanceCounterCategory.Delete( 'Delphi Counter Sample' );
end;


end.
